global script_node

local controls = FindNodeByName("AllControlsScript")
local prop = FindNodeByName("Ob_5_4Prop")
local handlestate

handlestate = 0

--Harmonic Generator

global function AnimDone()
	local anim
	local ce6 = FindNodeByName("ce6")
	
	ce6:Trigger()
	
	if (handlestate == 0) then
		anim = FindNodeByShortName("EM_ANIMATOR_P05_Harmonic_Anim_Panel05_Harmonic_Idle_6OC")	
	else
		anim = FindNodeByShortName("EM_ANIMATOR_P05_Harmonic_Anim_Panel05_Harmonic_Idle_12OC")
	end

	prop:PlayAnim(anim, 1, 0)
	FindNodeByName("Ob_5_4Sound"):StopTrigger()
	controls.script.TurnOnInterface()
	--Locking down mech
	controls.script.InteractDone()
end

global function PlayUp()
	local anim = FindNodeByShortName("EM_ANIMATOR_P05_Harmonic_Anim_Panel05_Harmonic_Turn_ClockWise")

	handlestate = 1

	FindNodeByName("Ob_5_4Sound"):Trigger()
	
	prop:PlayAnim(anim, 1, 0)
	prop:SetCallback(script_node, "AnimDone")
end

global function PlayDown()
	local anim = FindNodeByShortName("EM_ANIMATOR_P05_Harmonic_Anim_Panel05_Harmonic_Turn_AntiClockWise")

	handlestate = 0
	
	FindNodeByName("Ob_5_4Sound"):Trigger()		

	prop:PlayAnim(anim, 1, 0)
	prop:SetCallback(script_node, "AnimDone")
end

global function Interact()
	local doctor = GetActor("doctor")
	local amy = GetActor("amy")

	controls.script.TurnOffInterface()

	if (handlestate == 0) then
		PlayUp()
	else
		PlayDown()
	end
	
	FindNodeByName("Console5InteractableScript").script.Object4State = handlestate

	-- ConsoleDV == 0 is for when exploring tardis
	if controls.script.ConsoleDV == 0 then
		SayPrep("skip","async")

		if(FindNodeByName("CommonScripts").script.DoctorIsPlayer()) then
			--VO Console Control Text
			doctor::SID_2286:Harmonic Generator: This creates resonant harmonics where the TARDIS is about to materialise or dematerialise, so it doesn't cause too much disturbance.
			doctor::SID_2287:And by "disturbance", I mean a massive sonic boom, and a 4-dimensional crisis. Not good, in other words.
		else
			--VO Console Control Text
			amy::SID_2288:This must be important, the Doctor always uses it before using the appeary/disappeary thingy. Everything goes a bit wobbly when it's on.
		end
	end
end

global function DummyCallback()
end

global function ResetControl()
	local anim

	if handlestate == 0 then
		anim = FindNodeByShortName("EM_ANIMATOR_P05_Harmonic_Anim_Panel05_Harmonic_Idle_6OC")
	else
		anim = FindNodeByShortName("EM_ANIMATOR_P05_Harmonic_Anim_Panel05_Harmonic_Turn_AntiClockWise")
	end

	prop:SetCallback(script_node, "DummyCallback")	-- overrides the current callback so nothing happens
	prop:PlayAnim(anim, 1, 0)
	FindNodeByTag("Ob6_4Sound"):StopTrigger()
	handlestate = 0
end
